package coreservlets.tags;

import java.io.*;
import javax.servlet.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import coreservlets.listeners.*;

/** Klasa InitialCompanyNameListener posiada metody statyczne, ktre
 *  udostpniaj aktualn i poprzedni nazw firmy. Lecz aby mc
 *  uy tych metod na stronach JSP, potrzebny jest jawny kod Java,
 *  a gdyby informacje miay by udostpniane przez utworzone w tym celu
 *  komponenty JavaBean, obsuga wynikw ich dziaania byaby niewygodna.
 *  Dlatego kod zosta przeniesiony do wasnego znacznika.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */

public class FormerCompanyNameTag extends SimpleTagSupport {
  private boolean useFullDescription = false;
  
  public void doTag() throws JspException, IOException {
    PageContext pageContext = (PageContext) getJspContext();
    ServletContext context = pageContext.getServletContext();
    String formerCompanyName =
     InitialCompanyNameListener.getFormerCompanyName(context);
    JspWriter out = pageContext.getOut();
    if (useFullDescription) {
      String formerCompanyDescription = "";
      if (!formerCompanyName.equals("")) {
        formerCompanyDescription = 
          "(wczeniej " + formerCompanyName + ")";
      }
      out.print(formerCompanyDescription);
    } else {
      out.print(formerCompanyName);
    }
  }

  /** Jeeli uytkownik przypisze atrybutowi fullDescription
   *  warto "true" (wielkimi, maymi lub mieszanymi literami),
   *  zmiennej useFullDescription rwnie zostanie przypisana warto true.
   *  W przeciwnym razie jej wartoci pozostanie false.
   */
  public void setFullDescription(String flag) {
    if (flag.equalsIgnoreCase("true")) {
      useFullDescription = true;
    }
  }
}
